#ifndef DM_SHARED_TASK_H
#define DM_SHARED_TASK_H
#include "dm_nutypedefs.h"
#include "dm_os.h"
#include "dm_errors.h"

// See top of source file for documentation.

// SubTaskPtr is pointer to func with no args returning INT32
typedef INT32 (*SubTaskPtr)(UINT32 param);
typedef struct
{
    INT32 (*SubTaskPtr)(void *argList);
    void *argList;
}SHARED_SUBTASK_ENTRY;

struct SharedTask_TaskInfo
{
    SHARED_SUBTASK_ENTRY pEntryPoint;
    INT32      iSleepTime;
};

class SharedTask
{
public:
    SharedTask( SHARED_SUBTASK_ENTRY *pTaskList, UINT8 iNumTasks, UINT32 param);
    ~SharedTask();
    void Run();

    SHARED_SUBTASK_ENTRY *GetEntryPoint()
    {
        return &(m_pTasks->pEntryPoint);
    }

private:
    SharedTask_TaskInfo * m_pTasks;
    UINT8 m_iNumTasks;
    UINT32 m_param;

};
#endif
